/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import com.mojang.blaze3d.matrix.MatrixStack;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class DialogScreen
extends Screen {
    public static final ITextComponent CANCEL = new StringTextComponent("Cancel");
    public static final ITextComponent CONFIRM = new StringTextComponent("Confirm");
    private int left;
    private int top;
    private int xSize;
    private int ySize;
    private final AnimatorScreen parent;
    protected Button confirm;
    protected Button cancel;

    public DialogScreen(ITextComponent title, AnimatorScreen parent) {
        super(title);
        this.parent = parent;
        this.setDimensions(176, 166);
    }

    public static void handleDefaultKeys(int keycode, Button confirm, Button cancel) {
        if (keycode == 257 || keycode == 335) {
            if (confirm != null && confirm.field_230693_o_) {
                confirm.func_230930_b_();
            }
        } else if (keycode == 256 && cancel != null && cancel.field_230693_o_) {
            cancel.func_230930_b_();
        }
    }

    public static int parse(String value, int fallback) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return fallback;
        }
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
        this.parent.func_231158_b_(mc, width, height);
    }

    protected void func_231160_c_() {
        this.left = (this.field_230708_k_ - this.xSize) / 2;
        this.top = (this.field_230709_l_ - this.ySize) / 2;
    }

    public final void setDimensions(int x, int y) {
        this.xSize = x;
        this.ySize = y;
    }

    public final void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.parent.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        DialogScreen.func_238467_a_((MatrixStack)stack, (int)this.left, (int)this.top, (int)(this.left + this.xSize), (int)(this.top + this.ySize), (int)-1711276032);
        this.field_230712_o_.func_243246_a(stack, this.field_230704_d_, (float)(this.left + 5), (float)(this.top + 5), 0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231046_a_(int code, int scan, int modifiers) {
        DialogScreen.handleDefaultKeys(code, this.confirm, this.cancel);
        return super.func_231046_a_(code, scan, modifiers);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231178_ax__() {
        return false;
    }

    public void showParent() {
        this.field_230706_i_.func_147108_a((Screen)this.parent);
    }

    public AnimatorScreen getParent() {
        return this.parent;
    }

    public int left() {
        return this.left;
    }

    public int top() {
        return this.top;
    }

    public int dWidth() {
        return this.xSize;
    }

    public int dHeight() {
        return this.ySize;
    }

    protected void cancel_clicked(Button button) {
        this.showParent();
    }
}

